// MSCommTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "string.h"
#include "iostream.h"
#include "math.h"
#include "MSCommTest.h"
#include "MSCommTestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMSCommTestDlg dialog

CMSCommTestDlg::CMSCommTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMSCommTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMSCommTestDlg)
	m_strMyTest = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMSCommTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMSCommTestDlg)
	DDX_Control(pDX, IDC_MSCOMM1, m_msComm);
	DDX_Text(pDX, IDC_MYTEST, m_strMyTest);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMSCommTestDlg, CDialog)
	//{{AFX_MSG_MAP(CMSCommTestDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_TEST, OnTest)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMSCommTestDlg message handlers

BOOL CMSCommTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
    ConfigureCOM(); ///QCI

    // TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMSCommTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMSCommTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMSCommTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}
/////////////////////////////////////////////////////////////////////////////
void CMSCommTestDlg::ConfigureCOM() ///QCI
// Configure Comm Port
/////////////////////////////////////////////////////////////////////
{
    // setup com port 1
    m_msComm.SetCommPort(1); // COM1
    m_msComm.SetSettings("57600,N,8,2");
    m_msComm.SetInputLen(0);
    m_msComm.SetPortOpen(TRUE);

    // set flag for comm port enabled
    m_bCommEnabled = TRUE;
}
/////////////////////////////////////////////////////////////////////
void CMSCommTestDlg::OnTest() ///QCI
/////////////////////////////////////////////////////////////////////
{
    CString strCmd, strIn, strOutput, strMod, strDone;
	int intMod, intMask, intFinal;
    m_strMyTest = "";
	UpdateData(FALSE);
 	// send clear poll (cpl)
    strCmd.Format("@16 1 8192 %c",13);
    SendCommand(strCmd, strIn);
    Sleep(500);
	// send load and run program (lrp)
    // lrp 0, load and run program 0 from memory
    strCmd.Format("@16 156 512 %c",13);
    SendCommand(strCmd, strIn);
	Sleep(500);
	do 
	{
		Sleep(100);
		// poll for response (por)
		// por, poll for response from controller
		strCmd.Format("@16 27 %c",13);
		SendCommand(strCmd, strIn);
		strOutput = strIn;
		strMod = strOutput.Mid(10, 4);
		intMask = 2000;
		intMod = atoi (strMod);
		intFinal = intMod & intMask;
	} while (intFinal != 2000);
	m_strMyTest = "Bit 13 is Set, Output = " + strOutput;
	UpdateData(FALSE);
	// Anything to be done after the check should be here
	// send read register (rrg)
    // rrg 1, read register 1 (actual position)
    strCmd.Format("|16 12 1 %c",13);
    SendCommand(strCmd, strIn);
	strOutput = strIn;
	strMod = strOutput.Mid(8, 20);
	AfxMessageBox("Register 1 = " + strMod);
}
/////////////////////////////////////////////////////////////////////////////
int CMSCommTestDlg::SendCommand(CString & strCmd, CString & strIn)  ///QCI
// Send given command to given device
// Return 1 == Success
// Return 0 == Failure
// Return -1 == NAK received
/////////////////////////////////////////////////////////////////////
{
    // make sure the comm port is enabled
    if(!m_bCommEnabled)
        return 0;

    // send command
    m_msComm.SetOutput(COleVariant(strCmd));

    // wait for command to be sent.
    Sleep(50);

    // get response from device
    VARIANT var = m_msComm.GetInput();
    strIn = var.bstrVal;

    // fault out if not response
    if(strIn == ""){
        AfxMessageBox("Device did not respond");
        return 0;
    } 
    //  get rid of the carriage return
    int strLen = strIn.GetLength();
    strIn.SetAt(strLen-1,'\0');

    // return if nak received
    if (strLen > 0){
        if(strIn[0] == '!'){
            return(-1);
        }
    }
    // return success
    return(1);

}
